﻿namespace Marimo.開発支援.ソース生成ライブラリ
{
    /// <summary>
    /// 生成するソースコードの規定クラスとなります。
    /// </summary>
    public abstract class ソースコード
    {
        /// <summary>
        /// インデント一つを表す文字列です。
        /// </summary>
        protected const string 一インデント文字列 = "    ";

        /// <summary>
        /// 出力する言語を取得します。
        /// </summary>
        protected virtual 出力言語 出力言語 { get; set; }

        /// <summary>
        /// 各言語で自インスタンスを表すキーワードを取得します。
        /// </summary>
        protected string 自インスタンスキーワード
        {
            get
            {
                switch (出力言語)
                {
                    case 出力言語.Cシャープ:
                        return "this";
                    case 出力言語.VisualBasic:
                        return "Me";
                    default:
                        return null;
                }
            }
        }

        /// <summary>
        /// 生成されたソースコードを取得、設定します。
        /// </summary>
        public string ソース { get; protected set; }

        /// <summary>
        /// 親要素からインデントをいくつとるかを取得します。
        /// </summary>
        protected int インデント数 { get; private set; }

        /// <summary>
        /// 親要素に対するインデント文字列を取得します。
        /// </summary>
        protected string インデント
        {
            get
            {
                string 戻り値 = string.Empty;

                for (int i = 0; i < インデント数; i++)
                {
                    戻り値 += 一インデント文字列;
                }
                return 戻り値;
            }
        }

        /// <summary>
        /// ソースコードクラスのインスタンスを取得します。
        /// </summary>
        /// <param name="インデント数">親要素からインデントをいくつとるかです</param>
        protected ソースコード(int インデント数)
        {
            this.インデント数 = インデント数;
        }

        /// <summary>
        /// ソースコードの内容を返します。
        /// </summary>
        /// <returns>ソースコードの内容。</returns>
        public override string ToString()
        {
            return ソース;
        }
    }
}